package forkJoin;

import chapter8.TakeABreak;
import java.util.concurrent.RecursiveAction;

public class ExampleForkJoin extends RecursiveAction {
//To do Fork and Join our class needs to extend RecursiveAction
    int[] numbers;//array to process
    int pos=0;//current position in the array
    
    //extra information for the Fork Join
    final int threshold = 3;//number of elements each job will process
    int start,end;//the index numbers this thread is repsonsible for
    
    //Our constructor needs to be able to specify the start and end
    //points for this task
    
    public ExampleForkJoin(int[] numbers,int start,int end){
        this.numbers=numbers;
        this.start=start;
        this.end=end;
    }
    
    //Divide and Conquer...
    protected void compute(){
        if ((end-start)<threshold){
            //we have finished dividing up the task so just run it
            processData();
        } else {//divide it up some more
            int middle = (start-end)/2;
            //divide it into two tasks
            //the first task has the first half
            //and the second has the second half
            invokeAll(new ExampleForkJoin(numbers,start,middle),
                      new ExampleForkJoin(numbers,middle,end));
        }
    }
   
    //We only need to process from start to finish
    private synchronized void processData(){
        //check to make sure that we haven't reached the end.
        for (int i=start;i<end;i++)
            System.out.println("Number: "+numbers[i] //Print out i
                               +" Processed by: "
                               +Thread.currentThread().getName());
    }
}
